C      ******************************************************************
C      * Subroutine OutDat                                              *
C      * Outputs all values read in in subroutine InDat.                *
C      ******************************************************************
   	   SUBROUTINE OUTDAT
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
       CHARACTER*1 TAB
							CHARACTER*100 TOSS
							INTEGER C, L, LIN, S
	   
C      *------------------------*
C      * Set the tab character. *
C      *------------------------*
       TAB = CHAR(9)

C      *------------------------------------*
C      * Output the program version number. *
C      *------------------------------------*
       WRITE(YASOUT,*) 'YASEQL version number: 3.0.2'
       WRITE(YASOUT,*) 

C      *------------------------------------*
C      * Output the program version number. *
C      *------------------------------------*
       S = INDEX(FNAME,'     ')
       WRITE(YASOUT,*) 'Input file name -> ', FNAME(1:S)
       WRITE(YASOUT,*) 

C      *------------------------------------*
C      * Output the input-file description. *
C      *------------------------------------*
       WRITE(YASOUT,*) 'Input file description:'
       S = INDEX(COMMENT, '    ')
       WRITE(YASOUT,*) COMMENT(1:S)

C      *---------------------------------*
C      * Output the number of components *
C      *---------------------------------*
       WRITE(YASOUT,*)
	      WRITE(YASOUT,1000) NCOMP
 1000  FORMAT(' ','# OF COMP = ',I3)
	 
C      *-----------------------------------------------------------*
C      * Output the # of dependent species and the # of species in *
C      * the system.                                               *                         
C      *-----------------------------------------------------------*
							WRITE(YASOUT,1004) NDEPSP
 1004  FORMAT(' ', '# OF DEP. SPECIES = ',I3)
   	   WRITE(YASOUT,1005) NSPECIES
 1005  FORMAT(' ', '# OF SPECIES = ',I3)
       WRITE(YASOUT,*)
	   
C      *----------------------------------------------*
C      * Output the name of the component, its charge *
C      * and its Stype                                *
C      *----------------------------------------------*
       WRITE(YASOUT,*) 'COMP. NAME    ', TAB, 'CHG', TAB, 'STYPE'
	      DO 100 C=1,NCOMP
          WRITE(YASOUT,1001) LABELS(C), TAB, Z(C), TAB, HOLDSTYPE(C)
 1001     FORMAT(' ', A14, A1, I3, A1, A12)
  100  CONTINUE

C      *---------------------------------------------------------*
C      * Output the table of components and known concentrations *
C      * per layer 		                                            *
C      *---------------------------------------------------------*
       WRITE(YASOUT,*)
       WRITE(YASOUT,*) 'KT (mol) FOR EACH COMPONENT, PER LAYER'
       WRITE(YASOUT,1002) 'Component   ', (TAB,'Layer ',L,L=1,NLAYERS)
 1002  FORMAT(' ',A12,20(A1,A6,I2))
 1102  FORMAT(' ',A12,20(A1,A12))
							DO 105 C=1, NCOMP
	         WRITE(YASOUT,1003) LABELS(C),(TAB,KT(C,L), L=1, NLAYERS)
 1003     FORMAT(' ',A12, 10(A1,E12.4))
  105  CONTINUE
  
C      *-------------------------------------------------------*
C      * Output the dependent species name, the stoichiometric *
C      * coefficients for each component.                      *     
C      *-------------------------------------------------------*
       WRITE(YASOUT,*)
       WRITE(YASOUT,*) 'SPECIES TYPE AND STOICHIOMETRIC COEEFICIENTS ',
     > 'FOR DEPENDENT SPECIES'
       WRITE(YASOUT,1006) 'Dep. Sp.    ', TAB, 'Sp. type    ', 
     > (TAB,LABELS(C),C=1,NCOMP)
 1006  FORMAT(' ',A12,A1,A12,20(A1,A12))
	      DO 110 S=NCOMP+1, NSPECIES
	         WRITE(YASOUT,1007) LABELS(S),TAB, HOLDSTYPE(S),
     >    (TAB, SC(S,C), C=1, NCOMP)
 1007     FORMAT (' ',A12, A1, A12, 20(A1,F12.5))	 
  110  CONTINUE
	      WRITE(YASOUT,*)
	   
C      *-------------------------------------------------------------*
C      * Output the LogK terms for each dep. species, for eacy layer *
C      *-------------------------------------------------------------*
       WRITE(YASOUT,*) 'LOG OF EQUILIBRIUM CONSTANT FOR EACH ',
     > 'DEPENDENT SPECIES, PER LAYER'
       WRITE(YASOUT,1008) 'Dep. Sp.    ', (TAB, 'Layer ',L, L=1,NLAYERS)
 1008  FORMAT(' ',A12,20(A1,A6,I2))
	      DO 120 S=NCOMP+1, (NCOMP+NDEPSP)
		        WRITE(YASOUT,1010) LABELS(S), 
     >    (TAB, LOG10(EQCNST(S,L)),L=1, NLAYERS)
 1010     FORMAT(' ', A12, 10(A1,F12.4))
  120  CONTINUE
       WRITE(YASOUT,*)
	   
C      *--------------------------*
C      * Output the # of minerals *
C      *--------------------------*
       IF (NMNRLS.EQ.0) THEN
          WRITE(YASOUT,*) 'THERE ARE NO MINERALS IN THE SYSTEM'
          WRITE(YASOUT,*)
       ELSE
          WRITE(YASOUT,*)
	         WRITE(YASOUT,1011) NMNRLS
 1011     FORMAT(' ', '# OF MINERALS = ',I3)
          WRITE(YASOUT,*)

C         *-------------------------------------------------------*
C         * Output the mineral name and the stoichiometric        *
C         * coefficients for each component.                      *     
C         *-------------------------------------------------------*
          WRITE(YASOUT,*) 'MINERAL STOICHIOMETRIC COEFFICIENTS' 
          WRITE(YASOUT,1012) 'MINERAL    ', (TAB,LABELS(C),C=1,NCOMP)
 1012     FORMAT(' ',A12,20(A1,A10))
	         DO 140 S=1, NMNRLS
	            WRITE(YASOUT,1013) MINLAB(S),
     >       (TAB,MINSC(S,C), C=1, NCOMP)
 1013        FORMAT (' ',A12, 20(A1,F10.5))	 
  140     CONTINUE
	         WRITE(YASOUT,*)
	   
C         *---------------------------------------------------------*
C         * Output the mineral name and the fraction of the mineral *
C         * in each layer.                                          *     
C         *---------------------------------------------------------*
          WRITE(YASOUT,*) 'MINERAL FRACTION PER LAYER'
          WRITE(YASOUT,1014) 'Mineral     ', 
     >    (TAB,'Layer ',L, L=1,NLAYERS)
 1014     FORMAT(' ',A12,20(A1,A6,I2))
	         DO 150 S=1, NMNRLS
	            WRITE(YASOUT,1015) MINLAB(S),
     >       (TAB,MINFRAC(S,C), C=1, NLAYERS)
 1015        FORMAT (' ',A12, 20(A1,F12.5))	 
  150     CONTINUE
	         WRITE(YASOUT,*)

C         *---------------------------------------------------------*
C         * Output the mineral name, its weathering rate,  molecular*
C         * weight, HOrder and MOrder.                              *
C         *---------------------------------------------------------*
          WRITE(YASOUT,1016) 'MINERAL     ',TAB,'WTHR RATE ',
     >    TAB, 'MOLEC. WT.', TAB, 'HORDER    ', TAB, 'MORDER    '
 1016     FORMAT (' ',A12, 4(A1,A10))
	         DO 160 S=1, NMNRLS
	            WRITE(YASOUT,1017) MINLAB(S), TAB, WRATE(S), 
     >       TAB, MINMW(S), TAB, HORDER(S), TAB, MORDER(S)
 1017        FORMAT (' ',A12, A1, E10.3, 3(A1, F10.5))	 
  160     CONTINUE
	         WRITE(YASOUT,*)
       ENDIF

C      *---------------------------------------------*	   
C      * Output whether decomp is being used or not. *
C      *---------------------------------------------*	
       IF (USEDECOMP) THEN   
          WRITE(YASOUT,*) 'DECOMPOSITION ROUTINES USED'
          WRITE(YASOUT,*) 
       ELSE
          WRITE(YASOUT,*) 'DECOMPOSITION ROUTINES NOT USED,',
     >    ' INPUT DATA NOT USED'
          WRITE(YASOUT,*) 
          GOTO 8888
       ENDIF

C      *--------------------------------------------------------*
C      * Output initial amounts for cell, extr, lign and humus, *
C      * for each layer.                                        *
C      *--------------------------------------------------------*
       WRITE(YASOUT,*) 'INITIAL AMOUNTS - CELLULOSE, EXTRACTIVES, ',
     > 'LIGNIN, HUMUS'
       WRITE(YASOUT,1020) 'Soil part   ', (TAB, 'Layer ',L, L=1,NLAYERS)
 1020  FORMAT(' ',A12,20(A1,A6,I2))
       WRITE(YASOUT,1022) 'gC in Cellulose/m2',   
     > (TAB,CAMT(CELL, L), L=1,NLAYERS)
       WRITE(YASOUT,1022) 'gC in Extractives/m2', 
     > (TAB,CAMT(EXTR, L), L=1,NLAYERS)
       WRITE(YASOUT,1022) 'gC in Lignin/m2',
     > (TAB,CAMT(LIGN, L), L=1,NLAYERS)
       WRITE(YASOUT,1022) 'gC in Humus/m2',
     > (TAB,CAMT(HUMU, L), L=1,NLAYERS)
 1022  FORMAT(' ',A20,20(A1,E12.4))

C      *-----------------------------------------------*
C      * Output transformation rates and efficiencies. *
C      *-----------------------------------------------*
       WRITE(YASOUT,*) 
       WRITE(YASOUT,*) 'TRANSFORMATION RATES AND EFFICIENCIES'
       WRITE(YASOUT,1024) 'Transformation', TAB,
     > 'Rate          ', TAB,'Efficiency    ',TAB
       WRITE(YASOUT,1024) '              ', TAB, 
     > '  1/timestep  ',TAB,'   g __/g__   ',TAB
 1024  FORMAT(' ',3(A15,A1))
       WRITE(YASOUT,1026) 'CE',TAB,TRANRATE(CE), TAB,TRANEFFIC(CE)
       WRITE(YASOUT,1026) 'EL',TAB,TRANRATE(EL), TAB,TRANEFFIC(EL)
       WRITE(YASOUT,1026) 'HE',TAB,TRANRATE(HE), TAB,TRANEFFIC(HE)
       WRITE(YASOUT,1026) 'LE',TAB,TRANRATE(LE), TAB,TRANEFFIC(LE)
       WRITE(YASOUT,1026) 'LH',TAB,TRANRATE(LH), TAB,TRANEFFIC(LH)
 1026  FORMAT(' ',A15,2(A1,E15.5))
	      WRITE(YASOUT,*) 

C      *---------------------------------------*
C      * Output root fractionation parameters. *
C      *---------------------------------------*
	      WRITE(YASOUT,*) 
       WRITE(YASOUT,1029) 'ROOT FRACTIONATION PARAMETERS'
 1029  FORMAT(' ',A37)
       WRITE(YASOUT,1030) 'Root part',
     > (TAB,'Frac of C, Lyr ',L, L=1,NLAYERS)
 1030  FORMAT(' ',A9, 20(A1,A15,I2))
       WRITE(YASOUT,1032) 'Cellulose  ', 
     > (TAB, FRACTS(CELL,CARB,L), L=1,NLAYERS)
       WRITE(YASOUT,1032) 'Extractives', 
     > (TAB, FRACTS(EXTR,CARB,L), L=1,NLAYERS)
       WRITE(YASOUT,1032) 'Lignin     ', 
     > (TAB, FRACTS(LIGN,CARB,L), L=1,NLAYERS)
 1032  FORMAT(' ',A22,20(A1,E22.5))
	      WRITE(YASOUT,*) 

C      *---------------------------------------*
C      * Output leaf fractionation parameters. *
C      *---------------------------------------*
       WRITE(YASOUT,*) 'LEAF FRACTIONATION PARAMETERS'
       WRITE(YASOUT,1040) 'Leaf part         ',TAB,
     > 'Fraction of carbon  ',TAB
 1040  FORMAT(' ',2(A22,A1))
       WRITE(YASOUT,1042) 'Cellulose  ', TAB,LFFRACTS(CELL,CARB)
       WRITE(YASOUT,1042) 'Extractives', TAB,LFFRACTS(EXTR,CARB)
       WRITE(YASOUT,1042) 'Lignin     ', TAB,LFFRACTS(LIGN,CARB)
 1042  FORMAT(' ',A22,1(A1,E22.5))
	      WRITE(YASOUT,*) 

C      *----------------------------------*
C      * Output ILC shielding parameters. *
C      *----------------------------------*
       WRITE(YASOUT,*) 'ILC shielding parameter for cellulose ',
     > '(unitless): ', ILC(CELL)
       WRITE(YASOUT,*) 'ILC shielding parameter for extractives: ',
     > '(unitless): ', ILC(EXTR)
       WRITE(YASOUT,*) 

C      *-----------------------------------------------*
C      * Output maximal and optimal soil temperatures. *
C      *-----------------------------------------------*
       WRITE(YASOUT,*) 'maximal soil temperature (deg C): ',
     > MAXSLTEMP
       WRITE(YASOUT,*) 'optimal soil temperature (deg C): ',
     > OPTSLTEMP
       WRITE(YASOUT,*) 

C      *------------------------------*
C      * Output the Q function ratio. *
C      *------------------------------*
       WRITE(YASOUT,*) 'Q curve number: ', QCURVE
       WRITE(YASOUT,*) 

C      *--------------------------------*
C      * Output the N half saturation.  *
C      *--------------------------------*
       WRITE(YASOUT,*) 'N half saturation (g N/m**2): ', HALFSAT
       WRITE(YASOUT,*) 

C      *------------------------------------------------------*
C      * Output the optimal moisture, the moisture breadth    *
C      * parameter and the mositure skewness parameter.       *
C      *------------------------------------------------------*
       WRITE(YASOUT,*) 'Optimal soil moisture (mm avail water): ',
     > OPTMOIST
       WRITE(YASOUT,*) 
       WRITE(YASOUT,*) 'Moisture breadth parameter (unitless) : ', 
     > BRDTHMOIST
       WRITE(YASOUT,*) 
       WRITE(YASOUT,*) 'Moisture skewness parameter (unitless): ', 
     > SKEWMOIST
       WRITE(YASOUT,*) 

C      *-------------------------------------------------------*
C      * Output initial amount of nutrients in organic matter. *
C      *-------------------------------------------------------*
	      WRITE(YASOUT,*) 
       WRITE(YASOUT,1044) 
     > 'INITIAL AMOUNT OF NUTRIENTS IN ORGANIC MATTER'
 1044  FORMAT(' ',A46)
       WRITE(YASOUT,1046) 'Nutrient',
     > (TAB,'Amt (gC), Lyr ',L, L=1,NLAYERS)
 1046  FORMAT(' ',A9, 20(A1,A15,I2))
       WRITE(YASOUT,1048) 'Ca', 
     > (TAB, CA_IN_OM(L), L=1,NLAYERS)
       WRITE(YASOUT,1048) 'Mg', 
     > (TAB, MG_IN_OM(L), L=1,NLAYERS)
       WRITE(YASOUT,1048) 'K', 
     > (TAB, K_IN_OM(L), L=1,NLAYERS)
       WRITE(YASOUT,1048) 'P', 
     > (TAB, P_IN_OM(L), L=1,NLAYERS)
       WRITE(YASOUT,1048) 'S', 
     > (TAB, S_IN_OM(L), L=1,NLAYERS)
 1048  FORMAT(' ',A2,20(A1,E22.5))
	      WRITE(YASOUT,*) 

C      *---------------------------------------*
C      * Output nutrient decomposition rates. *
C      *---------------------------------------*
       WRITE(YASOUT,*) 
     > 'NUTRIENT DECOMPOSITION RATES (g nutr/(g nutrtimestep))'
       WRITE(YASOUT,1049) 'Ca', TAB, CA_MIN_RAT
       WRITE(YASOUT,1049) 'Mg', TAB, MG_MIN_RAT
       WRITE(YASOUT,1049) 'K ', TAB, K_MIN_RATE
 1049  FORMAT(' ',A2,1(A1,E22.5))
	      WRITE(YASOUT,*) 

C      *------------------------------------------------------------*
C      * Jump over output of decomposition data if decomp. not used *
C      *------------------------------------------------------------*
 8888  CONTINUE

C      *-----------------------------------------------------------*
C      * Output the phase information if there are phases present. *
C      *-----------------------------------------------------------*
       IF (NPHASES.EQ.0) THEN
          WRITE(YASOUT,*) 'THERE ARE NO QUICKLY DISSOLVING PHASES ',
     >    'IN THE SYSTEM.'
          WRITE(YASOUT,*) 
       ELSE
C         *-----------------------------*
C         * Output the number of phases *
C         *-----------------------------*
          WRITE(YASOUT,*) 'The number of phases is ',NPHASES
          WRITE(YASOUT,*)

C         *-----------------------------------*
C         * Output the stoichiometric matrix. *
C         *-----------------------------------*
          WRITE(YASOUT,*) 'STOICHIOMETRIC COEFFICIENTS ',
     >   'FOR QUICKLY DISSOLVING PHASES'
          WRITE(YASOUT,2006) 'Phase       ', (TAB,LABELS(C),C=1,NCOMP)
 2006     FORMAT(' ',A12,20(A1,A12))
	         DO 200 S=1, NPHASES
	            WRITE(YASOUT,2007) PHASENAMES(S),
     >                  (TAB,SP(S,C), C=1, NCOMP)
 2007        FORMAT (' ',A12, 20(A1,F12.5))	 
  200     CONTINUE
	         WRITE(YASOUT,*)

C         *--------------------------------------------------*
C         * Output the equilibrium constants for each layer. *
C         *--------------------------------------------------*
          WRITE(YASOUT,*) 'EQUILIBRIUM CONSTANT FOR EACH ',
     >    'PHASE, PER LAYER'
          WRITE(YASOUT,2008) 'Phase       ', 
     >    (TAB,'Layer ',L, L=1,NLAYERS)
 2008     FORMAT(' ',A12,20(A1,A6,I2))
	         DO 210 S=1, NPHASES
		           WRITE(YASOUT,2010) PHASENAMES(S), 
     >       (TAB,LOG10(SEC(S,L)),L=1, NLAYERS)
 2010        FORMAT(' ', A12, 10(A1,F12.4))
  210     CONTINUE
          WRITE(YASOUT,*)
       ENDIF

C      *---------------------------------------*
C      * Continue here if there are no phases. *
C      *---------------------------------------*
C      *-----------------------------*
C      * Output the activity choice. *
C      *-----------------------------*
       WRITE(YASOUT,2015) 'COMP/SPECIES',TAB,'ACTIVITY CHOICE'
 2015  FORMAT (' ',A12, A1, A15)	 
	      DO 230 S=1, NSPECIES
	         WRITE(YASOUT,2016) LABELS(S), TAB,HOLDAC(S)
 2016     FORMAT (' ',A12, A1, A12)	 
  230  CONTINUE
	      WRITE(YASOUT,*)

C      *-----------------------------------------------------------*
C      * If fake tree data is being used, output that information. *
C      *-----------------------------------------------------------*
       IF (STNDALONE) THEN
          WRITE(YASOUT,*) 'YASEQL ran as a stand-alone model, ',
     >    'fake tree data follows:'
       ELSE
          WRITE(YASOUT,*) 'YASEQL ran with TreGro, no fake tree ',
     >    'data used'
          GOTO 9999
       ENDIF

C      *--------------------------*
C      * Output the elapsed time. *
C      *--------------------------*
       WRITE(YASOUT,*)
       WRITE(YASOUT,1050) 'Elapsed time (sec)', ELAPT
 1050  FORMAT(' ' ,A19,F20.3)
       WRITE(YASOUT,*)

C      *--------------------------------------------------------*
C      * Output bulk density, catch area, theta, and thickness. *
C      *--------------------------------------------------------*
       WRITE(YASOUT,*) 'SOIL PARAMETERS'
       WRITE(YASOUT,1060) 'Item                ', 
     > (TAB,'Layer ',L, L=1,NLAYERS)
 1060  FORMAT(' ',A20,20(A1,A6,I2))
       WRITE(YASOUT,1062) 'Bulk Density (g/cm3)', 
     > (TAB,BLKDENS(L), L=1,NLAYERS)
       WRITE(YASOUT,1062) 'Catch Area (m2)     ',
     > (TAB,CATCHAREA(L), L=1,NLAYERS)
       WRITE(YASOUT,1062) 'Theta (cm3/cm3)     ',
     > (TAB,THETA(L), L=1,NLAYERS)
       WRITE(YASOUT,1062) 'Thickness (m)       ',
     > (TAB,THICKNESS(L), L=1,NLAYERS)
 1062  FORMAT(' ',A20,20(A1,E12.4))

C      *--------------------*
C      * Output water flux. *
C      *--------------------*
       WRITE(YASOUT,*)
       WRITE(YASOUT,*) 'WATER FLUXES (L/(m**2 sec)):'
       DO 1070 L = 0, NLAYERS
          WRITE(YASOUT,1072) 'Water flux layer ',L, TAB, WFLUX(L)
 1072     FORMAT(' ',A17,I2,A1,E12.4)
 1070  CONTINUE

C      *--------------------------------*
C      * Output rainfall concentration. *
C      *--------------------------------*
       WRITE(YASOUT,*)
       WRITE(YASOUT,*) 'RAINFALL CONCENTRATION (mol/L):'
       WRITE(YASOUT,*) 'Component',TAB, 'Rainfall Concentration (mol/L)'
       DO 1074 C = 1, NCOMP
          WRITE(YASOUT,1076) LABELS(C), TAB, TFCONC(C)
 1076     FORMAT(' ',A14,A1,E12.4)
 1074  CONTINUE

C      *-------------------------*
C      * Output nutrient uptake. *
C      *-------------------------*
       WRITE(YASOUT,*)
       WRITE(YASOUT,*) 'NUTRIENT UPTAKE (moles)'
       WRITE(YASOUT,1080) 'Nutrient    ', (TAB,'Layer ',L, L=1,NLAYERS)
 1080  FORMAT(' ',A12,20(A1,A6,I2))
       DO 1082 S = 1, SPNUM
          WRITE(YASOUT,1083) SPNAME(S), (TAB,NUTAKE(S,L),L=1,NLAYERS)
 1083     FORMAT(' ',A12,20(A1,E12.4))
 1082  CONTINUE

C      *--------------------------------------------*
C      * Output the root senescence for each layer. *
C      *--------------------------------------------*
       WRITE(YASOUT,*) 
       WRITE(YASOUT,*) 'ROOT SENESCENCE PER LAYER (gC)'
       WRITE(YASOUT,1090) ('Layer      ',L, TAB,L=1,NLAYERS)
 1090  FORMAT(' ',20(A10,I2,A1))
       WRITE(YASOUT,1092) (RTSENESC(L),TAB,L=1,NLAYERS)
 1092  FORMAT(' ',20(E12.4,A1))

C      *-----------------------------*
C      * Output the leaf senescence. *
C      *-----------------------------*
       WRITE(YASOUT,*)
       WRITE(YASOUT,*) 'LEAF SENESCENCE (gC)'
       WRITE(YASOUT,1100) 'Leaf senescence: ',LFSENESC
 1100  FORMAT(' ',A18,E12.4)

C      *----------------------------------------------*
C      * Output the soil temperatures for each layer. *
C      *----------------------------------------------*
       WRITE(YASOUT,*) 
       WRITE(YASOUT,*) 'SOIL TEMPERATURE PER LAYER (deg C)'
       WRITE(YASOUT,1090) ('Layer      ',L, TAB,L=1,NLAYERS)
       WRITE(YASOUT,1092) (SLTEMP(L),TAB,L=1,NLAYERS)

C      *---------------------------------------------------*
C      * Jump over output of fake tree data if TreGro used *
C      *---------------------------------------------------*
 9999  CONTINUE

       RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
